//*************+***************+***************+***************+***************+
//
//	SEKONIC
//	Device control Parameter header
//
//	FileName	: SkDvSrSeriesPrm.h
//	CPU			: x86
//	Compiler	: Microsoft Visual C++ 6.0 or later
//
//*************+***************+***************+***************+***************+
//	2013.04.24	add struct for Barcode Reader option
//	2012.08.06	add for SR-11000
//				"SkDvSr3500Prm.h"->"SkDvSrSeriesPrm.h"
//	2012.01.11	Into English
//	2011.10.27	for SR-3500 HYBRID
//*************+***************+***************+***************+***************+
#ifndef	INCLUDE_SKDVSRSERIESPRM_HEADER			// Multi include of a header is prevented.
#define	INCLUDE_SKDVSRSERIESPRM_HEADER

#pragma once


//*************+***************+***************+***************+***************+
//	define / typedef
//*************+***************+***************+***************+***************+

//-----+-------+-------+-------+-------+-------+-------+-------+
// Base value type
#ifndef SKDV_HANDLE_TYPE
#define SKDV_HANDLE_TYPE
typedef	void*			SkDvHandle;						// Handle of the control device
#endif
typedef	DWORD			SkDvStatus;						// Status Code


//*************+***************+***************+***************+***************+


//-----+-------+-------+-------+-------+-------+-------+-------+
// dot,meter					(SR-3500HYBRID)
#define DPI600_PPM								23622			// Pixels per meter(600dpi)	=23622.047 =600/0.0254
#define DPI300_PPM								11811			// Pixels per meter(300dpi)	=11811.024 =300/0.0254
#define DPI200_PPM								7874			// Pixels per meter(200dpi)	= 7874.016 =200/0.0254
#define DPI150_PPM								5906			// Pixels per meter(150dpi)	= 5905.512 =150/0.0254
#define DPI100_PPM								3937			// Pixels per meter(100dpi)	= 3937.007 =100/0.0254


//-----+-------+-------+-------+-------+-------+-------+-------+
// Enable/Disable
#define	SKDV_DISABLE							0				// Disable
#define	SKDV_ENABLE								1				// Enable


//-----+-------+-------+-------+-------+-------+-------+-------+
// Face
#define	SKDV_FRONT								0				// Front
#define	SKDV_BACK								1				// Back
#define	SKDV_FACE_NUM							2				// Number of items


//-----+-------+-------+-------+-------+-------+-------+-------+
// SK_DV_MODULE_INFO
#define	SKDV_INFO_MODEL_LEN						16				// model name string length
#define	SKDV_INFO_VER_LEN						16				// version string length


//-----+-------+-------+-------+-------+-------+-------+-------+
// SK_DEVICE_INFO
// length
#define	SKDV_GUID_LEN							36				// Length of GUID
#define	SKDV_PRODUCT_STR_MAX					15				// Max length of product name
#define	SKDV_SERIAL_LEN							9				// The number of bytes in the serial number (fixed length)
#define	SKDV_FIRM_VER_STR_MAX					4				// The maximum length version of the farm
#define	SKDV_FIRM_SUM_STR_MAX					4				// The maximum number of farm checksum
#define	SKDV_HARD_VER_STR_MAX					3				// The maximum number of hardware version

// szProduct
#define SKDV_PRODUCT_SR2300						"SR-2300"		// SR-2300
#define SKDV_PRODUCT_SR5500						"SR-5500"		// SR-5500
#define SKDV_PRODUCT_SR3500						"SR-3500"		// SR-3500
#define SKDV_PRODUCT_SR6000						"SR-6000"		// SR-6000
#define SKDV_PRODUCT_SR6500						"SR-6500"		// SR-6500
#define SKDV_PRODUCT_SR1800						"SR-1800"		// SR-1800
#define SKDV_PRODUCT_SR3500HYBRID				"SR-3500 HYBRID"// SR-3500HYBRID
#define SKDV_PRODUCT_SR11000					"SR-11000"		// SR-11000

// Main.dwOption
#define	SKDV_OPT_UNIT_MASK						0xffff0000		// Optional unit bit mask
#define	SKDV_OPT_UNIT_READER_F					0x80000000		// Exist MarkReading unit(front)
#define	SKDV_OPT_UNIT_READER_B					0x40000000		// Exist MarkReading unit(back)
#define	SKDV_OPT_UNIT_BCR						0x20000000		// Exist BarcodeReader unit
#define	SKDV_OPT_UNIT_PRINTER					0x10000000		// Exist Printer unit
#define	SKDV_OPT_UNIT_STACKER					0x08000000		// Exist Stacker unit
#define	SKDV_OPT_UNIT_IMAGE_1					0x04000000		// Exist ImageReading unit(CPU)
#define	SKDV_OPT_UNIT_IMAGE_2					0x02000000		// Exist ImageReading unit(FPGA)

#define	SKDV_OPT_FUNC_MASK						0x0000ff00		// Optional function bit mask
#define	SKDV_OPT_FUNC_WINDOW_LAYOUT				0x00000100		// Window layout function

// (reserved)
//	#define	SKDV_OPT_INTERFACE_MASK					0x0000000f		// Interface type bit mask
//	#define	SKDV_OPT_INTERFACE_USB_FULL				0x00000001		// USB full speed interface (USB1.1)
//	#define	SKDV_OPT_INTERFACE_USB_HIGH				0x00000002		// USB high-speed interface (USB2.0)

// Reader[].dwOption
#define	SKDV_OPT_SENSOR_TYPE_MASK				0x0000ff00		// Sensor type bit mask
#define	SKDV_OPT_SENSOR_TYPE_BIT				8				// Bit positions of sensor type
#define	SKDV_OPT_SENSOR_TYPE_ERR				0x0000ff00		// Error Sensor type
#define	SKDV_OPT_SENSOR_TYPE_RED_VIS			0x00000000		// Visible light
#define	SKDV_OPT_SENSOR_TYPE_INFRARED			0x00000100		// Near-infrared light

#define	SKDV_OPT_SENSOR_PITCH_MASK				0x000000ff		// Sensor pitch bit mask
#define	SKDV_OPT_SENSOR_PITCH_BIT				0				// Bit position of the sensor pitch
#define	SKDV_OPT_SENSOR_PITCH_ERR				0x000000ff		// Sensor pitch error
#define	SKDV_OPT_SENSOR_PITCH_1P6INCH			0x00000001		// 1/6inch
#define	SKDV_OPT_SENSOR_PITCH_02INCH			0x00000002		// 0.2inch
#define	SKDV_OPT_SENSOR_PITCH_02INCH_S			0x00000003		// 0.2inch-S
#define	SKDV_OPT_SENSOR_PITCH_025INCH			0x00000004		// 0.25inch
#define	SKDV_OPT_SENSOR_PITCH_03INCH			0x00000005		// 0.3inch
#define	SKDV_OPT_SENSOR_PITCH_03INCH_F			0x00000006		// 0.3inch-F
#define	SKDV_OPT_SENSOR_PITCH_6MM				0x00000007		// 6mm
#define	SKDV_OPT_SENSOR_PITCH_02INCH_K			0x00000008		// 0.2inch-K
#define	SKDV_OPT_SENSOR_PITCH_02INCH_SP			0x00000009		// 0.2inch-Special
#define	SKDV_OPT_SENSOR_PITCH_02INCH_C			0x0000000a		// 0.2inch-C

// Bcr.dwOption
#define	SKDV_OPT_BARCODE_MASK					0x000000ff		// Bar code reader bit mask
#define	SKDV_OPT_BARCODE_BIT					0				// Bit positions of Bar code reader
#define	SKDV_OPT_BARCODE_ERR					0x000000ff		// Not connected bar code reader
#define	SKDV_OPT_BARCODE_V						0x00000001		// Vertical
#define	SKDV_OPT_BARCODE_H						0x00000002		// Horizontal

// Printer.dwOption & Stacker.dwOption
#define	SKDV_OPT_PRINTER_CARTRIDGE				0x80000000		// With Cartridge

// Image1.dwOption
#define	SKDV_OPT_IMAGE_FACE_MASK				0xf0000000		// Face bit mask
#define	SKDV_OPT_IMAGE_FACE_FRONT				0x80000000		// Front
#define	SKDV_OPT_IMAGE_FACE_BACK				0x40000000		// Back
#define	SKDV_OPT_IMAGE_FACE_BOTH				0xc0000000		// Both


//-----+-------+-------+-------+-------+-------+-------+-------+
// Other										(SR-Series)
#define	SKDV_ID_LEN								20				// The number of bytes of identification codes


//-----+-------+-------+-------+-------+-------+-------+-------+
// SK_DV_SR3500_MODE							(SR-Series)

// (reserved).iFeedMode
#define	SKDV_FEED_MODE_AUTO						0				// (reserved)
#define	SKDV_FEED_MODE_MANUAL					1				// (reserved)

// (reserved).iFeedTime
#define	SKDV_FEED_TIME_MIN						0				// (reserved)
#define	SKDV_FEED_TIME_MAX						99				// (reserved)

// .dwDisableWarning
#define SKDV_WARN_AUTO_REJECT					0x00010000		// Enable automatic waste paper processing
#define SKDV_WARN_HOPPER_EMPTY					0x00020000		// Empty seat detection
#define SKDV_WARN_TM_ERROR						0x00040000		// Error detection timing mark
#define SKDV_WARN_DF_ERROR						0x00080000		// Double-feed detection
#define SKDV_WARN_LEFT_SKEW						0x00100000		// Left edge skew detection

// .MarkSkew.iRow
#define	SKDV_MARKSKEW_ROW_DISABLE				0				// Disable
#define	SKDV_MARKSKEW_ROW_MIN					1				// 
#define	SKDV_MARKSKEW_ROW_MAX					155				// Maximum value

// .MarkSkew.iLevel
#define	SKDV_MARKSKEW_LEVEL_MIN					1				// 
#define	SKDV_MARKSKEW_LEVEL_MAX					16				// Maximum value

// .iPanelOperation
// SKDV_DISABLE/SKDV_ENABLE

// .Buzzer.iVol
#define	SKDV_BUZZER_DISABLE						0				// Buzzer Off
#define	SKDV_BUZZER_MIN							1				// Buzzer Volume Min.
#define	SKDV_BUZZER_MAX							5				// Buzzer Volume Max.

// .Buzzer.iTone
#define	SKDV_BUZZER_TONE_A						1				// 
#define	SKDV_BUZZER_TONE_B						2				// 
#define	SKDV_BUZZER_TONE_C						3				// 

// .PSaving.iSleep
#define SKDV_SLEEPTIME_DISABLE					0				// 
#define SKDV_SLEEPTIME_MIN						1				// Minimum value
#define SKDV_SLEEPTIME_MAX						60				// Maximum value

// .PSaving.iStandby
#define SKDV_STANDBYTIME_DISABLE				0				// 
#define SKDV_STANDBYTIME_MIN					1				// Minimum value
#define SKDV_STANDBYTIME_MAX					60				// Maximum value


//-----+-------+-------+-------+-------+-------+-------+-------+
// SK_DV_SR3500MARK_CONF						(SR-Series)

// .iBackSideReading
// SKDV_DISABLE/SKDV_ENABLE

// .iColumns
#define	SKDV_COL_MAX							48				// Columns
#define	SKDV_ROW_MAX							155				// Rows

// .iReadingMethod
#define	SKDV_READ_FRONT_EDGE					1				// Top-end timing control type
#define	SKDV_READ_REAR_EDGE						2				// Bottom-end timing control type
#define	SKDV_READ_DIRECT						3				// Direct under type
#define	SKDV_READ_FACOM							4				// FACOM type
#define	SKDV_READ_BETWEEN_MARK_NS				5				// Mark to mark type(without top-end)
#define	SKDV_READ_BETWEEN_MARK					6				// Mark to mark type(with top-end)
#define	SKDV_READMETHOD_MIN						1				// 
#define	SKDV_READMETHOD_MAX						6				// Maximum value
#define	SKDV_READMETHOD_CNT						6				// Number of items

// .iCtrlMultiple
#define	SKDV_READ_EDGE_CTRL_MIN1				1				// Timing control value of minimum(Top-end)
#define	SKDV_READ_EDGE_CTRL_MIN2				2				// Timing control value of minimum(Bottom-end)
#define	SKDV_READ_EDGE_CTRL_MAX					9				// Timing control value of maximum

// .iThicknessType
#define	SKDV_THICKNESS_AUTO_DETECT 				0				// Automatic detection
#define	SKDV_THICKNESS_55_KG 					1				// 64g/m2  (55kg)
#define	SKDV_THICKNESS_72_KG					2				// 84g/m2  (72kg)
#define	SKDV_THICKNESS_90_KG					3				// 105g/m2 (90kg)
#define	SKDV_THICKNESS_110_KG					4				// 128g/m2 (110kg)
#define	SKDV_THICKNESS_135_KG					5				// 157g/m2 (135kg)
#define	SKDV_THICKNESS_MIN						0				// Minimum value
#define	SKDV_THICKNESS_MAX						5				//
#define	SKDV_THICKNESS_CNT						6				// Number of items


//-----+-------+-------+-------+-------+-------+-------+-------+
// SK_DV_SR3500IMG_CONF							(SR-3500HYBRID)

// .iScaningSide
#define	SKDV_SIDE_NONE							0				// Images do not scan
#define	SKDV_SIDE_BOTH							1				// Both
#define	SKDV_SIDE_FRONT							2				// Front
#define	SKDV_SIDE_BACK							3				// Back
#define	SKDV_SIDE_MAX							3				// Maximum value


// (reserved)
// .iScanCtrlType
//	#define SKDV_SCAN_CTRL_ONE						0				// One Scans
//	#define SKDV_SCAN_CTRL_BATCH					1				// Batch scanning (continuous feed)
//	#define SKDV_SCAN_CTRL_MAX						1				// Maximum value

// (reserved)
// .iFormLength
#define	SKDV_FORMLENGTH_DISABLE					0				// Disable
#define	SKDV_FORMLENGTH_MIN						1100			// 110.0[mm]
#define	SKDV_FORMLENGTH_MAX						3556			// 355.6[mm]


// .iLightColor[]
#define	SKDV_LIGHT_COLOR						0				// Color
#define	SKDV_LIGHT_GRAYSCALE					1				// Glayscale
#define	SKDV_LIGHT_RED							2				// Red
#define	SKDV_LIGHT_GREEN						3				// Green
#define	SKDV_LIGHT_BLUE							4				// Blue
#define	SKDV_LIGHT_MAX							4				// Maximum value


// .iResoType
#define	SKDV_RESO_TYPE_600DPI					0				// 600dpi
#define	SKDV_RESO_TYPE_300DPI					1				// 300dpi
#define	SKDV_RESO_TYPE_200DPI					2				// 200dpi
#define	SKDV_RESO_TYPE_150DPI					3				// 150dpi
#define	SKDV_RESO_TYPE_100DPI					4				// 100dpi
#define	SKDV_RESO_TYPE_MAX						4				// Maximum value


//-----+-------+-------+-------+-------+-------+-------+-------+
// iResoMode									(SR-3500HYBRID)
#define	SKDV_RESO_MODE_600DPI					0				// 600dpi driving
#define	SKDV_RESO_MODE_300DPI					1				// 300dpi driving
#define	SKDV_RESO_MODE_MAX						1				// Maximum value
#define	SKDV_RESO_MODE_NUM						2				// Number of items


//-----+-------+-------+-------+-------+-------+-------+-------+
// SK_DV_SR3500_STATUS_CHAR
#define	SKDV_ST_LEN								2				// ST1/ST2 length


//-----+-------+-------+-------+-------+-------+-------+-------+
// SK_DV_IMAGE_DATA_CONF						(SR-3500HYBRID)

// .iSide
//	SKDV_FRONT/SKDV_BACK

// .iColorType
#define	SKIM_IMAGE_WB							0				// Monochrome
#define	SKIM_IMAGE_GRAY							1				// Grayscale
#define	SKIM_IMAGE_COLOR						2				// Color
#define	SKIM_COLOR_TYPE_MIN						0				// Minimum value
#define	SKIM_COLOR_TYPE_MAX						2				// Maximum value

// .iRotate
#define	SKIM_IMAGE_ROTATE_0						0				// No rotation
#define	SKIM_IMAGE_ROTATE_90					1				// Rotated  90 degrees
#define	SKIM_IMAGE_ROTATE_180					2				// Rotated 180 degrees
#define	SKIM_IMAGE_ROTATE_270					3				// Rotated 270 degrees
#define	SKIM_IMAGE_ROTATE_MIN					0				// Minimum value
#define	SKIM_IMAGE_ROTATE_MAX					3				// Maximum value

// .iResolution
#define	SKIM_IMAGE_RESOLUTION_MIN				50				// Minimum value
#define	SKIM_IMAGE_RESOLUTION_MAX				600				// Maximum value


//-----+-------+-------+-------+-------+-------+-------+-------+
// SK_DV_IMAGE_FILE_CONF						(SR-3500HYBRID)

// .iEncoder
#define	SKIM_ENCODE_BMP							0				// BMP
#define	SKIM_ENCODE_GIF							1				// gif
#define	SKIM_ENCODE_JPEG						2				// Jpeg
#define	SKIM_ENCODE_PNG							3				// png
#define	SKIM_ENCODE_TIFF						4				// Tiff
#define	SKIM_ENCODE_MIN							0				// Minimum value
#define	SKIM_ENCODE_MAX							4				// Maximum value


// .iParam (Jpeg)
#define	SKIM_ENCODE_JPEG_PRM_MIN				0				// Minimum value
#define	SKIM_ENCODE_JPEG_PRM_MAX				100				// Maximum value

// .iParam (Tiff)
#define	SKIM_ENCODE_TIFF_PRM_LZW				2				// EncoderValueCompressionLZW
#define	SKIM_ENCODE_TIFF_PRM_NONE				6				// EncoderValueCompressionNone


//-----+-------+-------+-------+-------+-------+-------+-------+
// SkDv_ReqGetSensor - pdwSensor				(SR-Series)
#define SKDV_SENSOR_BIT_OUTPS					0x00000020		// OUTPS	
#define SKDV_SENSOR_BIT_RDPS					0x00000010		// RDPS		
#define SKDV_SENSOR_BIT_INPS					0x00000008		// INPS		
#define SKDV_SENSOR_BIT_PS0						0x00000004		// PS0		
#define SKDV_SENSOR_BIT_UPPS					0x00000002		// UPPS		
#define SKDV_SENSOR_BIT_DWPS					0x00000001		// DWPS		

#define SKDV_SENSOR_BIT_SKS						0x00001000		// SKS		
#define SKDV_SENSOR_BIT_MAIN_CVR				0x00000100		// MAIN-CVR	

#define SKDV_SENSOR_BIT_SPS3					0x00200000		// SPS3		(SR-11000)
#define SKDV_SENSOR_BIT_SPS2					0x00100000		// SPS2		(SR-11000)
#define SKDV_SENSOR_BIT_SPS1					0x00080000		// SPS1		(SR-11000)
#define SKDV_SENSOR_BIT_SPS						0x00040000		// SPS		(StackerOption)
#define SKDV_SENSOR_BIT_MPS						0x00020000		// MPS		(StackerOption)
#define SKDV_SENSOR_BIT_P2PS					0x00010000		// P2PS		(StackerOption)

#define SKDV_SENSOR_BIT_STK_SRPS				0x10000000		// SRPS		(SR-11000)
#define SKDV_SENSOR_BIT_STK_MRPS				0x08000000		// MRPS		(SR-11000)
#define SKDV_SENSOR_BIT_STK_SPS5				0x04000000		// SPS5		(SR-11000)
#define SKDV_SENSOR_BIT_STK_SPS4				0x02000000		// SPS4		(SR-11000)
#define SKDV_SENSOR_BIT_STK_CVR1				0x01000000		// STK-CVR1	(StackerOption)

#define SKDV_SENSOR_MASK_SR1800					0x0000113c		// SR-1800
#define SKDV_SENSOR_MASK_SR3500					0x0000113f		// SR-3500/6000/2300
#define SKDV_SENSOR_MASK_SR6500					0x0107113f		// SR-6500/5500
#define SKDV_SENSOR_MASK_SR3500HYBRID			0x0000013f		// SR-3500HYBRID
#define SKDV_SENSOR_MASK_SR11000				0x013f113f		// SR-11000

//-----+-------+-------+-------+-------+-------+-------+-------+
// SkDv_ReqMoveHopper - iUpDown					(SR-Series)
#define SKDV_HOPPER_DOWN						0				// Hopper down
#define SKDV_HOPPER_UP							1				// Hopper up


//-----+-------+-------+-------+-------+-------+-------+-------+
// SkDv_ReqEjectForm - iDirection				(SR-Series)
#define SKDV_EJECT_MAIN							1				// Eject sheet to Main Stacker (Immediate)
#define SKDV_EJECT_SELECT						2				// Eject sheet to Select Stacker (Immediate)
#define SKDV_EJECT_MAIN_NEXT					3				// Eject sheet to Main Stacker on the next SF command.
#define SKDV_EJECT_SELECT_NEXT					4				// Eject sheet to Select Stacker on the next SF command.


//-----+-------+-------+-------+-------+-------+-------+-------+
// BCR Reading area								(Barcode reader option)
//	Array number of SK_DV_OPT_BCR_CONF.iReadingArea
#define SKDV_BCR_READING_AREA_MAX				20				// Reading area array max
																// 0:Start Posisiton
																// 1,3,5,7,9,11,13,15,17,19:Range to read
																// 2,4,6,8,10,12,14,16,18:Range to unread

#define SKDV_BCR_READING_AREA_ENTIRE			0				// Read the entire


//-----+-------+-------+-------+-------+-------+-------+-------+
// BC type										(Barcode reader option)
//	SK_DV_OPT_BCR_CONF.dwEnableBcType(Multiple selected)
//	SK_DV_OPT_BCR_CONF.TypeOption[].dwBcType(One selected)
#define SKDV_BCR_CODE39							0x00000001		// CODE-39
#define	SKDV_BCR_ITF							0x00000002		// Interleaved 2 of 5
#define	SKDV_BCR_NW7							0x00000004		// NW-7
#define	SKDV_BCR_JAN_EAN_UPC					0x00000008		// JAN,EAN,UPC
#define	SKDV_BCR_CODE128						0x00000010		// Code-128
#define	SKDV_BCR_INDUSTRIAL2OF5					0x00000020		// Industrial 2 of 5
#define	SKDV_BCR_COOP2OF5						0x00000040		// COOP 2 of 5
#define	SKDV_BCR_CODE93							0x00000080		// CODE-93

//-----+-------+-------+-------+-------+-------+-------+-------+
// BC CheckDigit								(Barcode reader option)
//	SK_DV_OPT_BCR_CONF.CheckDigit.iCode39
//	SK_DV_OPT_BCR_CONF.CheckDigit.iItf
//	SK_DV_OPT_BCR_CONF.CheckDigit.iNw7
#define SKDV_BCR_CD_NONE						0				// None Check digit
#define SKDV_BCR_CD_ENABLE						1				// Enable Check digit

#define SKDV_BCR_CD_NW7_M16						1				// NW-7 Modulus 16
#define SKDV_BCR_CD_NW7_M11						2				// NW-7 Modulus 11
#define SKDV_BCR_CD_NW7_M10W2					3				// NW-7 Modulus 10 weight 2
#define SKDV_BCR_CD_NW7_M10W3					4				// NW-7 Modulus 10 weight 3
#define SKDV_BCR_CD_NW7_7DR						5				// NW-7 7 DR
#define SKDV_BCR_CD_NW7_WM11					6				// Weighted Modulus 11
#define SKDV_BCR_CD_NW7_RUNES					7				// Runes

//-----+-------+-------+-------+-------+-------+-------+-------+
// BC UPC-A Number of output digits				(Barcode reader option)
//	SK_DV_OPT_BCR_CONF.Option.iUpcA
#define SKDV_BCR_CD_UPC_A_DIGIT_12				0				// 12 digit output
#define SKDV_BCR_CD_UPC_A_DIGIT_13				1				// 13 digit output

//-----+-------+-------+-------+-------+-------+-------+-------+
// BC UPC-E System code							(Barcode reader option)
//	SK_DV_OPT_BCR_CONF.Option.iUpcE
#define SKDV_BCR_CD_UPC_E_NO_CODE				0				// Do not attach the system code
#define SKDV_BCR_CD_UPC_E_ADD_CODE				1				// Attach the system code


//-----+-------+-------+-------+-------+-------+-------+-------+
// Print buffer size							(Printer option)
#define SKDV_PRINT_BUFFER_SIZE					42				// 

//-----+-------+-------+-------+-------+-------+-------+-------+
// Print orientation							(Printer option)
#define SKDV_PRINT_ORIENT_0						1				// 
#define SKDV_PRINT_ORIENT_180					2				// 

//-----+-------+-------+-------+-------+-------+-------+-------+
// Print Mode									(Printer option)
#define SKDV_PRINT_MODE_AFTER_FEED				1				// 
#define	SKDV_PRINT_MODE_FEED_AND_PRINT			2				// 


//-----+-------+-------+-------+-------+-------+-------+-------+
// fnCalibrationCallBack - iSeqNum				(SR-3500HYBRID)
#define SKDV_CALIB_SEQ_START					0				// 
#define SKDV_CALIB_SEQ_GET_INFO					1				// 
#define SKDV_CALIB_SEQ_FIRST_FEED				2				// 
#define SKDV_CALIB_SEQ_CHK_BACKGROUND			3				// 
#define SKDV_CALIB_SEQ_START_FEED				4				// 
#define SKDV_CALIB_SEQ_ADJ_LED_ONTIME			5				// 
#define SKDV_CALIB_SEQ_SET_LED_ONTIME			6				// 
#define SKDV_CALIB_SEQ_CIS_BASE					7				// 
#define SKDV_CALIB_SEQ_CHK_CIS_BASE				8				// 
#define SKDV_CALIB_SEQ_SAVE						9				// 
#define SKDV_CALIB_SEQ_END_FEED					10				// 
#define SKDV_CALIB_SEQ_CHK_PLATEN				11				// 
#define SKDV_CALIB_SEQ_END						12				// 


//-----+-------+-------+-------+-------+-------+-------+-------+
// fnCalibrationCallBack - iSeqNum				(SR-3500HYBRID)
#define SKDV_CALIB_PROG_LOWER					0				// Minimum value
#define SKDV_CALIB_PROG_UPPER					100				// Maximum value


//*************+***************+***************+***************+***************+
//*************+***************+***************+***************+***************+

//-----+-------+-------+-------+-------+-------+-------+-------+
// Module Info
typedef struct tag_SK_DV_MODULE_INFO
{
	char	szModel		[SKDV_INFO_MODEL_LEN];					// Model name
	char	szVersion	[SKDV_INFO_VER_LEN];					// Version
}SK_DV_MODULE_INFO;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Device Info Base								(SR-Series)
typedef struct	tag_SK_DEVICE_INFO
{
	char	szGuid		[SKDV_GUID_LEN+1];						// Unique ID []
	char	szProduct	[SKDV_PRODUCT_STR_MAX+1];				// Product name
	char	szSerialNo	[SKDV_SERIAL_LEN+1];					// Serial number [IE]
	char	szFirmVer	[SKDV_FIRM_VER_STR_MAX+1];				// Firmware version
	char	szFirmSum	[SKDV_FIRM_SUM_STR_MAX+1];				// Firmware check sum
	char	szHardVer	[SKDV_HARD_VER_STR_MAX+1];				// Hardware version

	DWORD	dwOption;											// Option infomation
}SK_DEVICE_INFO;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Device Info									(SR-Series)
typedef struct	tag_SK_DV_SR3500_INFO
{
	SK_DEVICE_INFO		Main;									// Main unit
	SK_DEVICE_INFO		Reader[SKDV_FACE_NUM];					// Mark reading unit
	SK_DEVICE_INFO		Bcr;									// Barcode reader unit (option)
	SK_DEVICE_INFO		Printer;								// Printer unit (option)
	SK_DEVICE_INFO		Stacker;								// Stacker unit (option)
	SK_DEVICE_INFO		Image1;									// Image reading CPU unit (option)
	SK_DEVICE_INFO		Image2;									// Image reading FPGA unit (option)
}SK_DV_SR3500_INFO;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Device mode									(SR-Series)
typedef struct tag_SK_DV_SR3500_MODE
{
	int			iFeedMode;										// (reserved)
	int			iFeedTime;										// (reserved)
	DWORD		dwDisableWarning;								// DisableWarning
	struct tagMarkSkew{											// Mark skew
		int			iRow;											// Row
		int			iLevel;											// Mark level
	}MarkSkew;
	int			iPanelOperation;								// Panel Operation
	struct tagBuzzer{											// Buzzer
		int			iVol;											// Volume
		int			iTone;											// Tone
	}Buzzer;
	struct tagPSaving{											// Power Saving
		int			iSleep;											// Sleep time
		int			iStandby;										// Standby time
	}PSaving;
}SK_DV_SR3500_MODE;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Device Configuration for MarkSheet			(SR-Series)
typedef struct tag_SK_DV_SR3500MARK_CONF
{
	int			iBackSideReading;								// Use of Back Sensor Unit
	int			iColumns;										// Number of columns
	int			iReadingMethod;									// Reading method
	int			iCtrlMultiple;									// Control multiple value
	int			iThicknessType;									// Sheet paper weight (thickness)
}SK_DV_SR3500MARK_CONF;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Device Configuration for Image				(SR-3500HYBRID)
typedef struct tag_SK_DV_SR3500IMG_CONF
{
	int			iScanningSide;									// Scaning side
	int			iScanCtrlType;									// (reserved)
	int			iFormLengthMin;									// (reserved)
	int			iFormLengthMax;									// (reserved)
	int			iLightColor[SKDV_FACE_NUM];						// LightColor
	int			iResoType;										// Resolution
	int			iResoTypeY;										// (reserved)
}SK_DV_SR3500IMG_CONF;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Status code character						(SR-Series)
typedef struct tag_SK_DV_SR3500_STATUS_CHAR
{
	char	ST1[SKDV_ST_LEN];									// Status of front side
	char	ST2[SKDV_ST_LEN];									// Status of back side
	char	DIF1;
	char	DIF2;
}SK_DV_SR3500_STATUS_CHAR, *PSK_DV_SR3500_STATUS_CHAR;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Mark data infomation							(SR-Series)
typedef struct tag_SK_DV_MARK_INFO
{
	int		iType;												// Data type(16 levels)
	int		iRows;												// Number of rows
	int		iColumns;											// Number of columns
}SK_DV_MARK_INFO, *PSK_DV_MARK_INFO;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Printer Configuration						(SR-Series option)
typedef struct	tag_SK_DV_OPT_PRN_CONF
{
	int		iEnable;											// Enable printer ()
	int		iStartPos;											// Print starting position from the leading edge of the sheet
	int		iOrientation;										// Print orientation
	int		iFontSize;											// Font size
	int		iFontSpace;											// Font space
	int		iPrintMode;											// Print mode
}SK_DV_OPT_PRN_CONF;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Barcode Reader Configration option			(SR-Series option)
typedef struct	tag_SK_DV_OPT_BCR_TYPE_OPT
{
	int		iCheckDigit;										// 
	int		iOption1;											// 
	int		iOption2;											// 
}SK_DV_OPT_BCR_TYPE_OPT;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Barcode Reader Configuration					(SR-Series option)
typedef struct	tag_SK_DV_OPT_BCR_CONF
{
	int		iEnable;											// Enable BCR
	int		iReadingArea[SKDV_BCR_READING_AREA_MAX];			// Reading area [mm]
	DWORD	dwEnableBcType;										// Enable Barcode type

	struct tagCheckDigit{										// Check Digit
		int		iCode39;											// CODE-39
		int		iItf;												// ITF
		int		iNw7;												// NW-7
		int		iReserved1;											// (reserved)It must be set to 0
		int		iReserved2;											// (reserved)It must be set to 0
		int		iReserved3;											// (reserved)It must be set to 0
	}CheckDigit;

	struct tagOption{											// Option
		int		iUpcA;												// UPC-A Number of output digits
		int		iUpcE;												// UPC-E System code
		int		iReserved1;											// (reserved)It must be set to 0
		int		iReserved2;											// (reserved)It must be set to 0
		int		iReserved3;											// (reserved)It must be set to 0
		int		iReserved4;											// (reserved)It must be set to 0
	}Option;
}SK_DV_OPT_BCR_CONF;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Image data Configuration						(SR-3500HYBRID)
typedef struct tag_SK_DV_IMAGE_DATA_CONF
{
	int			iFace;											// Face
	RECT		rectCutout;										// Cutout area
	int			iColorType;										// Color type
	int			iRotate;										// Rotate
	int			iResolution;									// Resolution
	DWORD		dwOption;										// (reserved)
}SK_DV_IMAGE_DATA_CONF;


//-----+-------+-------+-------+-------+-------+-------+-------+
// Image file Configuration						(SR-3500HYBRID)
typedef struct tag_SK_DV_IMAGE_FILE_CONF
{
	int			iEncoder;										// Encoder
	int			iParam;											// Encoder parameter
}SK_DV_IMAGE_FILE_CONF;




//*************+***************+***************+***************+***************+
//*************+***************+***************+***************+***************+

// Save the image data file (another thread) callback function definition
//												(SR-3500HYBRID)
#ifndef FN_SK_DV_SAVEIMAGE_CALLBACK_DEFINE
#define FN_SK_DV_SAVEIMAGE_CALLBACK_DEFINE
typedef BOOL (CALLBACK *FN_SK_DV_SAVEIMAGE_CALLBACK)(SK_DV_IMAGE_DATA_CONF* pImageDataConf, SK_DV_IMAGE_FILE_CONF* pImageFileConf, char* pszFilename, SkDvStatus Status, LPVOID lpParameter);
#endif



#endif
